/*
 * GPS.h
 *
 *  Created on: Apr 18, 2015
 *      Author: Jordan
 */

#ifndef USER_CODE_GPS_H_
#define USER_CODE_GPS_H_

#define PI 3.141592653

typedef struct {
	uint32 time_of_fix;
	char receiver_status;
	float32 latitude;
	char latitude_direction;
	float32 longitude;
	char longitude_direction;
	float32 speed_over_ground;
	float32 course_over_ground;
	uint32 date_of_fix;
	float32 magnetic_variation;
	char magnetic_variation_direction;
} nmea_gprmc_t;

typedef struct {
	uint32 time_of_fix;
	float32 latitude;
	char latitude_direction;
	float32 longitude;
	char longitude_direction;
	uint32 fix_quality;
	uint32 n_satellites;
	float32 hdop;
	float32 altitude_msl;
	char altitude_msl_units;
	float32 altitude_geoid;
	char altitude_geoid_units;
	float32 last_update;
	uint32 station_id;
} nmea_gpgga_t;

void gps_init();
void parse(char data);
void update_gps();
float32 get_gps_lat();
float32 get_gps_lon();
float32 get_gps_heading();
float32 get_gps_speed();
uint32 get_gps_fix();
uint32 get_gps_sats();
float32 get_gps_hdop();
float32 get_gps_alt();
uint32 from_hex(char a);

#endif /* USER_CODE_GPS_H_ */
